#!/bin/bash

PS3='Please enter your choice: '
options=("Create" "Modify" "Delete" "Quit")
select opt in "${options[@]}" 
do
    case $opt in
        "Create")
	    echo ""
            PS3='Network or USB: '
	    type=("Network" "USB")
	    echo "Create Print Queue.."
	    echo ""
	    select NoU in "${type[@]}"
	    do
		case $NoU in
			"Network")
				echo ""
	   			echo "Enter queue name:"
	    			read newQ
				echo ""
	   			echo "Enter The Printer IP address:"
	    			read Ip
				echo ""
	    			PS3='Enter connection type: '
	    			options=("socket" "IPP" "LPD")
	    			select conn in "${options[@]}"
	    			do
					case $conn in 
		  			 "socket")
						echo ""
						lpadmin -p "$newQ" -E -v socket://"$Ip"  -P /usr/share/ppd/Generic_PPD/Generic_UPD_Series.ppd >/dev/null 2>&1 && echo -e "#CUPS-COMMAND\nAutoConfigure" | lp -d "$newQ" >/dev/null 2>&1
						if [ $? -eq 0 ]; then
							echo "$newQ is sucessfully created!"
						else
							echo "Creation of $newQ is failed!"
							exit -1;
						fi
						#lp -d "$newQ" /home/skapas/Desktop/scriptQ/autoConfig
						break
						;;
					  "IPP")
						  echo ""
						  lpadmin -p "$newQ" -E -v ipp://"$Ip"  -P /usr/share/ppd/Generic_PPD/Generic_UPD_Series.ppd >/dev/null 2>&1 && echo -e "#CUPS-COMMAND\nAutoConfigure" | lp -d "$newQ" >/dev/null 2>&1
						  if [ $? -eq 0 ]; then
						  	echo "$newQ is sucessfully created!"
						  else
						  	echo "Creation of $newQ is failed!"
						  	exit -1;
						  fi
				          break
						  ;;
					   "LPD")
						  echo ""
						  lpadmin -p "$newQ" -E -v lpd://"$Ip"/"$newQ"  -P /usr/share/ppd/Generic_PPD/Generic_UPD_Series.ppd >/dev/null 2>&1 && echo -e "#CUPS-COMMAND\nAutoConfigure" | lp -d "$newQ" >/dev/null 2>&1
						  if [ $? -eq 0 ]; then
						  	echo "$newQ is sucessfully created!"
						  else
						  	echo "Creation of $newQ is failed!"
						  	exit -1;
						  fi
                          break
                          ;;
				esac
				done
				break
				;;
			"USB")
				echo ""
				usburi=`lpinfo -v | grep -i usb | awk -F" " '{print $NF}'`
				echo "USB URI -- $usburi"
				echo ""
				echo "Enter queue name:"
                read usbQ
				lpadmin -p "$usbQ" -E -v "$usburi"  -P /usr/share/ppd/Generic_PPD/Generic_UPD_Series.ppd >/dev/null 2>&1 && echo -e "#CUPS-COMMAND\nAutoConfigure" | lp -d "$usbQ" >/dev/null 2>&1
				if [ $? -eq 0 ]; then
					echo "$usbQ is sucessfully created!"
				else
					echo "Creation of $usbQ is failed!"
					exit -1;
				fi
				break
				;;
	   esac
	   done
	   break
            ;;
        "Modify")
	    echo ""
            echo -e "Modify Existing Print Queue \n"
	    listQueue=`lpstat -a | awk '{print $1}'`
		if [ -z "$listQueue" ]; then
			echo "There is no existing queue in the machine!!!"
			exit -2;
		fi
		arrIndex=1
	    echo ""
        echo -e "Existing queues\n"
		for i in $listQueue 
		do
			arrQueue[${arrIndex}]="$i"
			echo "${arrIndex}) $i"
			arrIndex=`expr $arrIndex + 1`
		done
	    echo ""
	    echo -n "Select an existing queue to modify: "
	    read Qname
		re='^[0-9]+$'
        if ! [[ $Qname =~ $re ]] ; then
        echo "error: Not a number" >&2; exit 1
        fi
        if [ $Qname -ge $arrIndex ]
        then
        echo "No such queue"
        break
        fi
	    echo ""
	    echo "Enter an updated printer IP address:"
	    read newIp
            echo ""
            PS3='Enter connection type: '
	    			options=("socket" "IPP" "LPD")
	    			select conn in "${options[@]}"
	    			do
					case $conn in 
		  			 "socket")
						echo ""
						lpadmin -p "${arrQueue[$Qname]}" -E -v socket://"$newIp" >/dev/null 2>&1  && echo -e "#CUPS-COMMAND\nAutoConfigure" | lp -d "${arrQueue[$Qname]}" >/dev/null
						if [ $? -eq 0 ]; then
			echo "Print queue \"${arrQueue[$Qname]}\" is successfully updated with printer IP address $newIp !"
                else
                        echo "Modification of \"${arrQueue[$Qname]}\" is failed!"
                        exit -1;
                fi
						#lp -d "$newQ" /home/skapas/Desktop/scriptQ/autoConfig
						break
						;;
					  "IPP")
						  echo ""
                                                  lpadmin -p "${arrQueue[$Qname]}" -E -v ipp://"$newIp" >/dev/null 2>&1  && echo -e "#CUPS-COMMAND\nAutoConfigure" | lp -d "${arrQueue[$Qname]}" >/dev/null
						  
						 if [ $? -eq 0 ]; then
			echo "Print queue \"${arrQueue[$Qname]}\" is successfully updated with printer IP address $newIp !"
                else
                        echo "Modification of \"${arrQueue[$Qname]}\" is failed!"
                        exit -1;
                fi
				          break
						  ;;
					   "LPD")
						  echo ""
                                                  lpadmin -p "${arrQueue[$Qname]}" -E -v lpd://"$newIp"/"${arrQueue[$Qname]}" >/dev/null 2>&1  && echo -e "#CUPS-COMMAND\nAutoConfigure" | lp -d "${arrQueue[$Qname]}" >/dev/null
						  
						  if [ $? -eq 0 ]; then
			echo "Print queue \"${arrQueue[$Qname]}\" is successfully updated with printer IP address $newIp !"
                else
                        echo "Modification of \"${arrQueue[$Qname]}\" is failed!"
                        exit -1;
                fi
             break
             ;;
             esac
             done
             break
             ;;	    
	    	
        "Delete")
            echo -e "Delete Print Queue"
	    echo ""
	    listQueue=`lpstat -a | awk '{print $1}'`
	    	if [ -z "$listQueue" ]; then
                        echo "There is no existing queue in the machine!!!"
                        exit -2;
             	fi
		arrIndex=1
	    echo -e "Existing queues\n"
		     for i in $listQueue
                	do
                        	arrQueue[${arrIndex}]="$i"
                        	echo "${arrIndex}) $i"
                        	arrIndex=`expr $arrIndex + 1`
                	done
	    echo ""
	    echo -n "Select an existing queue to delete: "
	    read Dqname
		re='^[0-9]+$'
        if ! [[ $Dqname =~ $re ]] ; then
        echo "error: Not a number" >&2; exit 1
        fi
        if [ $Dqname -ge $arrIndex ]
        then
        echo "No such queue"
        break
        fi
	    echo ""
	    echo -n "Do you want to delete print queue "\"${arrQueue[$Dqname]}"\" ? [y or n] "
	    read ans
	    echo ""
	    if [ "${ans}" = "Y" ] | [ "${ans}" = "y" ]
	    then
		echo ""
		echo "Delete...."
		lpadmin -x "${arrQueue[$Dqname]}"
		echo ""
		echo "Print queue \"${arrQueue[$Dqname]}\" has been deleted."
		echo ""
	    elif [ "${ans}" = "N" ] | [ "${ans}" = "n" ]
	    then
		break;
	    else
		echo "Enter valid option"
	    fi
	    break
            ;;
        "Quit")
            break
            ;;
        *) echo "invalid option $REPLY";;
    esac
done
